/******************************************************************************
Copyright (c) Freescale Semiconductor 2006
File Name		 :	$RCSfile: xgate.h,v $
Location		 :	EKB
Date Created	 :	27/02/2006
Current Revision :	$Revision: 1.0 $
Notes            :  
*******************************************************************************/

#ifndef __XGATE_H_
#define __XGATE_H_

/* XGATE vector table entry */
typedef void (*_NEAR XGATE_Function)(int);
typedef struct {
  XGATE_Function pc;        /* pointer to the handler */
  int dataptr;              /* pointer to the data of the handler */
} XGATE_TableEntry;

#pragma push								/* save current segment definitions */

#pragma CONST_SEG __GPAGE_SEG XGATE_VECTORS  /* for the HCS12X/XGATE shared setup, HCS12X needs global addressing to access teh vector table. */

#define XGATE_VECTOR_OFFSET 9							   /* the first elements are unused and need not to be allocated (to save space) */

extern const XGATE_TableEntry XGATE_VectorTable[];

#pragma pop									/* restore previous segment definitions */


/* this code is to demonstrate how to share date between XGATE and S12X */
#pragma push								/* save current segment definitions */

#pragma DATA_SEG SHARED_DATA /* allocate the following variables in the segment SHARED_DATA */
extern int shared_counter;

#pragma pop									/* restore previous segment definitions */


#endif /* __XGATE_H_ */
